<?php declare(strict_types=1);
/**
 * This file is automatically generated by the build_docs.php file
 * and is used only for autocompletion in multiple IDEs
 * don't modify it manually.
 */

namespace danog\MadelineProto;

use __PHP_Incomplete_Class;
use Amp\ByteStream\Pipe;
use Amp\ByteStream\ReadableStream;
use Amp\ByteStream\WritableStream;
use Amp\Cancellation;
use Amp\Future;
use Amp\Http\Server\Request as ServerRequest;
use Closure;
use danog\MadelineProto\Broadcast\Action;
use danog\MadelineProto\Broadcast\Progress;
use danog\MadelineProto\Broadcast\Status;
use danog\MadelineProto\EventHandler\Action\Cancel;
use danog\MadelineProto\EventHandler\Attributes\Handler;
use danog\MadelineProto\EventHandler\Keyboard;
use danog\MadelineProto\EventHandler\Media;
use danog\MadelineProto\EventHandler\Media\Audio;
use danog\MadelineProto\EventHandler\Media\Document;
use danog\MadelineProto\EventHandler\Media\Photo;
use danog\MadelineProto\EventHandler\Media\Video;
use danog\MadelineProto\EventHandler\Message;
use danog\MadelineProto\EventHandler\Message\Entities\Code;
use danog\MadelineProto\EventHandler\Message\Entities\Email;
use danog\MadelineProto\EventHandler\Message\Entities\Mention;
use danog\MadelineProto\EventHandler\Message\Entities\MessageEntity;
use danog\MadelineProto\EventHandler\Message\Entities\Phone;
use danog\MadelineProto\EventHandler\Message\Entities\Pre;
use danog\MadelineProto\EventHandler\Message\Entities\Spoiler;
use danog\MadelineProto\EventHandler\Message\Entities\Url;
use danog\MadelineProto\EventHandler\Participant\Admin;
use danog\MadelineProto\EventHandler\Participant\Member;
use danog\MadelineProto\EventHandler\Pinned;
use danog\MadelineProto\EventHandler\Update;
use danog\MadelineProto\EventHandler\User\Status\Emoji;
use danog\MadelineProto\EventHandler\User\Username;
use danog\MadelineProto\Ipc\Client;
use danog\MadelineProto\Ipc\EventHandlerProxy;
use danog\MadelineProto\Ipc\Server;

/** @psalm-suppress PossiblyNullReference, PropertyNotSetInConstructor */
abstract class InternalDoc
{
    protected APIWrapper $wrapper;
    /** @var \danog\MadelineProto\Namespace\Auth $auth */
    public $auth;
    /** @var \danog\MadelineProto\Namespace\Account $account */
    public $account;
    /** @var \danog\MadelineProto\Namespace\Users $users */
    public $users;
    /** @var \danog\MadelineProto\Namespace\Contacts $contacts */
    public $contacts;
    /** @var \danog\MadelineProto\Namespace\Messages $messages */
    public $messages;
    /** @var \danog\MadelineProto\Namespace\Updates $updates */
    public $updates;
    /** @var \danog\MadelineProto\Namespace\Photos $photos */
    public $photos;
    /** @var \danog\MadelineProto\Namespace\Upload $upload */
    public $upload;
    /** @var \danog\MadelineProto\Namespace\Help $help */
    public $help;
    /** @var \danog\MadelineProto\Namespace\Channels $channels */
    public $channels;
    /** @var \danog\MadelineProto\Namespace\Bots $bots */
    public $bots;
    /** @var \danog\MadelineProto\Namespace\Payments $payments */
    public $payments;
    /** @var \danog\MadelineProto\Namespace\Stickers $stickers */
    public $stickers;
    /** @var \danog\MadelineProto\Namespace\Phone $phone */
    public $phone;
    /** @var \danog\MadelineProto\Namespace\Langpack $langpack */
    public $langpack;
    /** @var \danog\MadelineProto\Namespace\Folders $folders */
    public $folders;
    /** @var \danog\MadelineProto\Namespace\Stats $stats */
    public $stats;
    /** @var \danog\MadelineProto\Namespace\Chatlists $chatlists */
    public $chatlists;
    /** @var \danog\MadelineProto\Namespace\Stories $stories */
    public $stories;
    /** @var \danog\MadelineProto\Namespace\Premium $premium */
    public $premium;

    /**
     * Export APIFactory instance with the specified namespace.
     * @psalm-suppress InaccessibleProperty
     */
    protected function exportNamespaces(): void
    {
        $this->auth ??= new \danog\MadelineProto\Namespace\AbstractAPI('auth');
        $this->auth->setWrapper($this->wrapper);
        $this->account ??= new \danog\MadelineProto\Namespace\AbstractAPI('account');
        $this->account->setWrapper($this->wrapper);
        $this->users ??= new \danog\MadelineProto\Namespace\AbstractAPI('users');
        $this->users->setWrapper($this->wrapper);
        $this->contacts ??= new \danog\MadelineProto\Namespace\AbstractAPI('contacts');
        $this->contacts->setWrapper($this->wrapper);
        $this->messages ??= new \danog\MadelineProto\Namespace\AbstractAPI('messages');
        $this->messages->setWrapper($this->wrapper);
        $this->updates ??= new \danog\MadelineProto\Namespace\AbstractAPI('updates');
        $this->updates->setWrapper($this->wrapper);
        $this->photos ??= new \danog\MadelineProto\Namespace\AbstractAPI('photos');
        $this->photos->setWrapper($this->wrapper);
        $this->upload ??= new \danog\MadelineProto\Namespace\AbstractAPI('upload');
        $this->upload->setWrapper($this->wrapper);
        $this->help ??= new \danog\MadelineProto\Namespace\AbstractAPI('help');
        $this->help->setWrapper($this->wrapper);
        $this->channels ??= new \danog\MadelineProto\Namespace\AbstractAPI('channels');
        $this->channels->setWrapper($this->wrapper);
        $this->bots ??= new \danog\MadelineProto\Namespace\AbstractAPI('bots');
        $this->bots->setWrapper($this->wrapper);
        $this->payments ??= new \danog\MadelineProto\Namespace\AbstractAPI('payments');
        $this->payments->setWrapper($this->wrapper);
        $this->stickers ??= new \danog\MadelineProto\Namespace\AbstractAPI('stickers');
        $this->stickers->setWrapper($this->wrapper);
        $this->phone ??= new \danog\MadelineProto\Namespace\AbstractAPI('phone');
        $this->phone->setWrapper($this->wrapper);
        $this->langpack ??= new \danog\MadelineProto\Namespace\AbstractAPI('langpack');
        $this->langpack->setWrapper($this->wrapper);
        $this->folders ??= new \danog\MadelineProto\Namespace\AbstractAPI('folders');
        $this->folders->setWrapper($this->wrapper);
        $this->stats ??= new \danog\MadelineProto\Namespace\AbstractAPI('stats');
        $this->stats->setWrapper($this->wrapper);
        $this->chatlists ??= new \danog\MadelineProto\Namespace\AbstractAPI('chatlists');
        $this->chatlists->setWrapper($this->wrapper);
        $this->stories ??= new \danog\MadelineProto\Namespace\AbstractAPI('stories');
        $this->stories->setWrapper($this->wrapper);
        $this->premium ??= new \danog\MadelineProto\Namespace\AbstractAPI('premium');
        $this->premium->setWrapper($this->wrapper);
    }
    /**
         * Convert MTProto parameters to bot API parameters.
         *
         * @param array $data Data
         */
    public function MTProtoToBotAPI(array $data): array
    {
        return $this->wrapper->getAPI()->MTProtoToBotAPI($data);
    }
    /**
     * MTProto to TD params.
     *
     * @param mixed $params Params
     */
    public function MTProtoToTd(mixed &$params): array
    {
        return $this->wrapper->getAPI()->MTProtoToTd($params);
    }
    /**
     * MTProto to TDCLI params.
     *
     * @param mixed $params Params
     */
    public function MTProtoToTdcli(mixed $params): array
    {
        return $this->wrapper->getAPI()->MTProtoToTdcli($params);
    }
    /**
     * Accept call.
     */
    public function acceptCall(int $id): void
    {
        $this->wrapper->getAPI()->acceptCall($id);
    }
    /**
     * Accept secret chat.
     *
     * @param array $params Secret chat ID
     */
    public function acceptSecretChat(array $params): void
    {
        $this->wrapper->getAPI()->acceptSecretChat($params);
    }
    /**
     * Create array.
     *
     * @param mixed ...$params Params
     */
    public static function arr(mixed ...$params): array
    {
        return \danog\MadelineProto\Tools::arr(...$params);
    }
    /**
     * base64URL decode.
     *
     * @param string $data Data to decode
     */
    public static function base64urlDecode(string $data): string
    {
        return \danog\MadelineProto\Tools::base64urlDecode($data);
    }
    /**
     * Base64URL encode.
     *
     * @param string $data Data to encode
     */
    public static function base64urlEncode(string $data): string
    {
        return \danog\MadelineProto\Tools::base64urlEncode($data);
    }
    /**
     * Convert bot API parameters to MTProto parameters.
     *
     * @param array $arguments Arguments
     */
    public function botAPIToMTProto(array $arguments): array
    {
        return $this->wrapper->getAPI()->botAPIToMTProto($arguments);
    }
    /**
     * Login as bot.
     *
     * @param string $token Bot token
     */
    public function botLogin(string $token): ?array
    {
        return $this->wrapper->getAPI()->botLogin($token);
    }
    /**
     * Executes a custom broadcast action with all peers (users, chats, channels) of the bot.
     *
     * Will return an integer ID that can be used to:
     *
     * - Get the current broadcast progress with getBroadcastProgress
     * - Cancel the broadcast using cancelBroadcast
     *
     * Note that to avoid manually polling the progress,
     * MadelineProto will also periodically emit updateBroadcastProgress updates,
     * containing a Progress object for all broadcasts currently in-progress.
     *
     * @param Action $action A custom, serializable Action class that will be called once for every peer.
     * @param float|null $delay Number of seconds to wait between each peer.
     */
    public function broadcastCustom(\danog\MadelineProto\Broadcast\Action $action, ?\danog\MadelineProto\Broadcast\Filter $filter = null, ?float $delay = null): int
    {
        return $this->wrapper->getAPI()->broadcastCustom($action, $filter, $delay);
    }
    /**
     * Forwards a list of messages to all peers (users, chats, channels) of the bot.
     *
     * Will return an integer ID that can be used to:
     *
     * - Get the current broadcast progress with getBroadcastProgress
     * - Cancel the broadcast using cancelBroadcast
     *
     * Note that to avoid manually polling the progress,
     * MadelineProto will also periodically emit updateBroadcastProgress updates,
     * containing a Progress object for all broadcasts currently in-progress.
     *
     * @param mixed      $from_peer   Bot API ID or Update, from where to forward the messages.
     * @param list<int>  $message_ids IDs of the messages to forward.
     * @param bool       $drop_author If true, will forward messages without quoting the original author.
     * @param bool       $pin         Whether to also pin the last sent message.
     * @param float|null $delay       Number of seconds to wait between each peer.
     */
    public function broadcastForwardMessages(mixed $from_peer, array $message_ids, bool $drop_author = false, ?\danog\MadelineProto\Broadcast\Filter $filter = null, bool $pin = false, ?float $delay = null): int
    {
        return $this->wrapper->getAPI()->broadcastForwardMessages($from_peer, $message_ids, $drop_author, $filter, $pin, $delay);
    }
    /**
     * Sends a list of messages to all peers (users, chats, channels) of the bot.
     *
     * A simplified version of this method is also available: broadcastForwardMessages can work with pre-prepared messages.
     *
     * Will return an integer ID that can be used to:
     *
     * - Get the current broadcast progress with getBroadcastProgress
     * - Cancel the broadcast using cancelBroadcast
     *
     * Note that to avoid manually polling the progress,
     * MadelineProto will also periodically emit updateBroadcastProgress updates,
     * containing a Progress object for all broadcasts currently in-progress.
     *
     * @param array      $messages The messages to send: an array of arrays, containing parameters to pass to messages.sendMessage.
     * @param bool       $pin      Whether to also pin the last sent message.
     * @param float|null $delay    Number of seconds to wait between each peer.
     */
    public function broadcastMessages(array $messages, ?\danog\MadelineProto\Broadcast\Filter $filter = null, bool $pin = false, ?float $delay = null): int
    {
        return $this->wrapper->getAPI()->broadcastMessages($messages, $filter, $pin, $delay);
    }
    /**
     * Fork a new green thread and execute the passed function in the background.
     *
     * @template T
     *
     * @param \Closure(...):T $callable Function to execute
     * @param mixed ...$args Arguments forwarded to the function when forking the thread.
     *
     * @return Future<T>
     *
     * @psalm-suppress InvalidScope
     */
    public static function callFork(\Generator|\Amp\Future|callable $callable, ...$args): \Amp\Future
    {
        return \danog\MadelineProto\AsyncTools::callFork($callable, ...$args);
    }
    /**
     * Get the file that is currently being played.
     *
     * Will return a string with the object ID of the stream if we're currently playing a stream, otherwise returns the related LocalFile or RemoteUrl.
     */
    public function callGetCurrent(int $id): \danog\MadelineProto\RemoteUrl|\danog\MadelineProto\LocalFile|string|null
    {
        return $this->wrapper->getAPI()->callGetCurrent($id);
    }
    /**
     * Play file in call.
     */
    public function callPlay(int $id, \danog\MadelineProto\LocalFile|\danog\MadelineProto\RemoteUrl|\Amp\ByteStream\ReadableStream $file): void
    {
        $this->wrapper->getAPI()->callPlay($id, $file);
    }
    /**
     * Play files on hold in call.
     */
    public function callPlayOnHold(int $id, \danog\MadelineProto\LocalFile|\danog\MadelineProto\RemoteUrl|\Amp\ByteStream\ReadableStream ...$files): void
    {
        $this->wrapper->getAPI()->callPlayOnHold($id, ...$files);
    }
    /**
     * Set output file or stream for incoming OPUS audio packets in a call.
     *
     * Will write an OGG OPUS stream to the specified file or stream.
     */
    public function callSetOutput(int $id, \danog\MadelineProto\LocalFile|\Amp\ByteStream\WritableStream $file): void
    {
        $this->wrapper->getAPI()->callSetOutput($id, $file);
    }
    /**
     * Whether we can convert any audio/video file to a VoIP OGG OPUS file, or the files must be preconverted using @libtgvoipbot.
     */
    public static function canConvertOgg(): bool
    {
        return \danog\MadelineProto\Tools::canConvertOgg();
    }
    /**
     * Cancel a running broadcast.
     *
     * @param integer $id Broadcast ID
     *
     */
    public function cancelBroadcast(int $id): void
    {
        $this->wrapper->getAPI()->cancelBroadcast($id);
    }
    /**
     * Close connection with client, connected via web.
     *
     * @param string $message Message
     */
    public static function closeConnection(string $message): void
    {
        \danog\MadelineProto\Tools::closeConnection($message);
    }
    /**
     * Complete 2FA login.
     *
     * @param string $password Password
     */
    public function complete2faLogin(string $password): array
    {
        return $this->wrapper->getAPI()->complete2faLogin($password);
    }
    /**
     * Complet user login using login code.
     *
     * @param string $code Login code
     */
    public function completePhoneLogin(string $code): array
    {
        return $this->wrapper->getAPI()->completePhoneLogin($code);
    }
    /**
     * Complete signup to Telegram.
     *
     * @param string $first_name First name
     * @param string $last_name  Last name
     */
    public function completeSignup(string $first_name, string $last_name = ''): array
    {
        return $this->wrapper->getAPI()->completeSignup($first_name, $last_name);
    }
    /**
     * Discard call.
     *
     * @param int<1, 5> $rating  Call rating in stars
     * @param string    $comment Additional comment on call quality.
     */
    public function discardCall(int $id, \danog\MadelineProto\VoIP\DiscardReason $reason = \danog\MadelineProto\VoIP\DiscardReason::HANGUP, ?int $rating = null, ?string $comment = null): void
    {
        $this->wrapper->getAPI()->discardCall($id, $reason, $rating, $comment);
    }
    /**
     * Discard secret chat.
     *
     * @param int $chat Secret chat ID
     */
    public function discardSecretChat(int $chat): void
    {
        $this->wrapper->getAPI()->discardSecretChat($chat);
    }
    /**
     * Downloads a file to the browser using the specified session file.
     */
    public static function downloadServer(string $session): void
    {
        \danog\MadelineProto\MTProto::downloadServer($session);
    }
    /**
     * Download file to browser.
     *
     * Supports HEAD requests and content-ranges for parallel and resumed downloads.
     *
     * @param array|string|FileCallbackInterface|\danog\MadelineProto\EventHandler\Message $messageMedia File to download
     * @param null|callable                                                                $cb           Status callback (can also use FileCallback)
     * @param null|int                                                                     $size         Size of file to download, required for bot API file IDs.
     * @param null|string                                                                  $mime         MIME type of file to download, required for bot API file IDs.
     * @param null|string                                                                  $name         Name of file to download, required for bot API file IDs.
     */
    public function downloadToBrowser(\danog\MadelineProto\FileCallbackInterface|\danog\MadelineProto\EventHandler\Message|array|string $messageMedia, ?callable $cb = null, ?int $size = null, ?string $name = null, ?string $mime = null, ?\Amp\Cancellation $cancellation = null): void
    {
        $this->wrapper->getAPI()->downloadToBrowser($messageMedia, $cb, $size, $name, $mime, $cancellation);
    }
    /**
     * Download file to callable.
     * The callable must accept two parameters: string $payload, int $offset
     * The callable will be called (possibly out of order, depending on the value of $seekable).
     *
     * @param mixed                          $messageMedia File to download
     * @param callable|FileCallbackInterface $callable     Chunk callback
     * @param callable                       $cb           Status callback
     * @param bool                           $seekable     Whether the callable can be called out of order
     * @param int                            $offset       Offset where to start downloading
     * @param int                            $end          Offset where to stop downloading (inclusive)
     * @param int                            $part_size    Size of each chunk
     */
    public function downloadToCallable(mixed $messageMedia, callable $callable, ?callable $cb = null, bool $seekable = true, int $offset = 0, int $end = -1, ?int $part_size = null, ?\Amp\Cancellation $cancellation = null): void
    {
        $this->wrapper->getAPI()->downloadToCallable($messageMedia, $callable, $cb, $seekable, $offset, $end, $part_size, $cancellation);
    }
    /**
     * Download file to directory.
     *
     * @param mixed                        $messageMedia File to download
     * @param string|FileCallbackInterface $dir          Directory where to download the file
     * @param callable                     $cb           Callback
     *
     * @return non-empty-string Downloaded file name
     */
    public function downloadToDir(mixed $messageMedia, \danog\MadelineProto\FileCallbackInterface|string $dir, ?callable $cb = null, ?\Amp\Cancellation $cancellation = null): string
    {
        return $this->wrapper->getAPI()->downloadToDir($messageMedia, $dir, $cb, $cancellation);
    }
    /**
     * Download file.
     *
     * @param mixed                        $messageMedia File to download
     * @param string|FileCallbackInterface $file         Downloaded file path
     * @param callable                     $cb           Callback
     *
     * @return non-empty-string Downloaded file name
     */
    public function downloadToFile(mixed $messageMedia, \danog\MadelineProto\FileCallbackInterface|string $file, ?callable $cb = null, ?\Amp\Cancellation $cancellation = null): string
    {
        return $this->wrapper->getAPI()->downloadToFile($messageMedia, $file, $cb, $cancellation);
    }
    /**
     * Download file to amphp/http-server response.
     *
     * Supports HEAD requests and content-ranges for parallel and resumed downloads.
     *
     * @param array|string|FileCallbackInterface|\danog\MadelineProto\EventHandler\Message $messageMedia File to download
     * @param ServerRequest                                                                $request      Request
     * @param callable                                                                     $cb           Status callback (can also use FileCallback)
     * @param null|int                                                                     $size         Size of file to download, required for bot API file IDs.
     * @param null|string                                                                  $name         Name of file to download, required for bot API file IDs.
     * @param null|string                                                                  $mime         MIME type of file to download, required for bot API file IDs.
     */
    public function downloadToResponse(\danog\MadelineProto\FileCallbackInterface|\danog\MadelineProto\EventHandler\Message|array|string $messageMedia, \Amp\Http\Server\Request $request, ?callable $cb = null, ?int $size = null, ?string $mime = null, ?string $name = null, ?\Amp\Cancellation $cancellation = null): \Amp\Http\Server\Response
    {
        return $this->wrapper->getAPI()->downloadToResponse($messageMedia, $request, $cb, $size, $mime, $name, $cancellation);
    }
    /**
     * Download file to an amphp stream, returning it.
     *
     * @param mixed    $messageMedia File to download
     * @param callable $cb           Callback
     * @param int      $offset       Offset where to start downloading
     * @param int      $end          Offset where to end download
     */
    public function downloadToReturnedStream(mixed $messageMedia, ?callable $cb = null, int $offset = 0, int $end = -1, ?\Amp\Cancellation $cancellation = null): \Amp\ByteStream\ReadableStream
    {
        return $this->wrapper->getAPI()->downloadToReturnedStream($messageMedia, $cb, $offset, $end, $cancellation);
    }
    /**
     * Download file to stream.
     *
     * @param mixed                                               $messageMedia File to download
     * @param mixed|FileCallbackInterface|resource|WritableStream $stream       Stream where to download file
     * @param callable                                            $cb           Callback
     * @param int                                                 $offset       Offset where to start downloading
     * @param int                                                 $end          Offset where to end download
     */
    public function downloadToStream(mixed $messageMedia, mixed $stream, ?callable $cb = null, int $offset = 0, int $end = -1, ?\Amp\Cancellation $cancellation = null): void
    {
        $this->wrapper->getAPI()->downloadToStream($messageMedia, $stream, $cb, $offset, $end, $cancellation);
    }
    /**
     * Asynchronously write to stdout/browser.
     *
     * @param string $string Message to echo
     */
    public static function echo(string $string): void
    {
        \danog\MadelineProto\AsyncTools::echo($string);
    }
    /**
     * Get final element of array.
     *
     * @template T
     * @param  array<T> $what Array
     * @return T
     */
    public static function end(array $what): mixed
    {
        return \danog\MadelineProto\Tools::end($what);
    }
    /**
     * Convert a message and a set of entities to HTML.
     *
     * @param list<MessageEntity|array{_: string, offset: int, length: int}> $entities
     * @param bool                                                           $allowTelegramTags Whether to allow telegram-specific tags like tg-spoiler, tg-emoji, mention links and so on...
     */
    public static function entitiesToHtml(string $message, array $entities, bool $allowTelegramTags = false): string
    {
        return \danog\MadelineProto\StrTools::entitiesToHtml($message, $entities, $allowTelegramTags);
    }
    /**
     * Export authorization.
     *
     * @return array{0: (int|string), 1: string}
     */
    public function exportAuthorization(): array
    {
        return $this->wrapper->getAPI()->exportAuthorization();
    }
    /**
     * Extract file info from bot API message.
     *
     * @param array $info Bot API message object
     */
    public static function extractBotAPIFile(array $info): ?array
    {
        return \danog\MadelineProto\MTProto::extractBotAPIFile($info);
    }
    /**
     * Extract a message constructor from an Updates constructor.
     */
    public function extractMessage(array $updates): array
    {
        return $this->wrapper->getAPI()->extractMessage($updates);
    }
    /**
     * Extract a message ID from an Updates constructor.
     */
    public function extractMessageId(array $updates): int
    {
        return $this->wrapper->getAPI()->extractMessageId($updates);
    }
    /**
     * Extract an update message constructor from an Updates constructor.
     */
    public function extractMessageUpdate(array $updates): array
    {
        return $this->wrapper->getAPI()->extractMessageUpdate($updates);
    }
    /**
     * Extract Update constructors from an Updates constructor.
     *
     * @return array<array>
     */
    public function extractUpdates(array $updates): array
    {
        return $this->wrapper->getAPI()->extractUpdates($updates);
    }
    /**
     * Get contents of remote file asynchronously.
     *
     * @param string $url URL
     */
    public function fileGetContents(string $url): string
    {
        return $this->wrapper->getAPI()->fileGetContents($url);
    }
    /**
     * Asynchronously lock a file
     * Resolves with a callbable that MUST eventually be called in order to release the lock.
     *
     * @param  string                                                          $file      File to lock
     * @param  integer                                                         $operation Locking mode
     * @param  float                                                           $polling   Polling interval
     * @param  ?Cancellation                                                   $token     Cancellation token
     * @param  ?Closure                                                        $failureCb Failure callback, called only once if the first locking attempt fails.
     * @return ($token is null ? (Closure(): void) : ((Closure(): void)|null))
     */
    public static function flock(string $file, int $operation, float $polling = 0.1, ?\Amp\Cancellation $token = null, ?\Closure $failureCb = null): ?\Closure
    {
        return \danog\MadelineProto\AsyncTools::flock($file, $operation, $polling, $token, $failureCb);
    }
    /**
     * When was full info for this chat last cached.
     *
     * @param mixed $id Chat ID
     */
    public function fullChatLastUpdated(mixed $id): int
    {
        return $this->wrapper->getAPI()->fullChatLastUpdated($id);
    }
    /**
     * Get info about the logged-in user, not cached.
     */
    public function fullGetSelf(): array|false
    {
        return $this->wrapper->getAPI()->fullGetSelf();
    }
    /**
     * Generate MTProto vector hash.
     *
     * Returns a vector hash.
     *
     * @param array $longs IDs
     */
    public static function genVectorHash(array $longs): string
    {
        return \danog\MadelineProto\Tools::genVectorHash($longs);
    }
    /**
     * Get admin IDs (equal to all user report peers).
     */
    public function getAdminIds(): array
    {
        return $this->wrapper->getAPI()->getAdminIds();
    }
    /**
     * Get all pending and running calls, indexed by user ID.
     *
     * @return array<int, VoIP>
     */
    public function getAllCalls(): array
    {
        return $this->wrapper->getAPI()->getAllCalls();
    }
    /**
     * Get full list of MTProto and API methods.
     */
    public function getAllMethods(): array
    {
        return $this->wrapper->getAPI()->getAllMethods();
    }
    /**
     * Get authorization info.
     *
     * @return \danog\MadelineProto\API::NOT_LOGGED_IN|\danog\MadelineProto\API::WAITING_CODE|\danog\MadelineProto\API::WAITING_SIGNUP|\danog\MadelineProto\API::WAITING_PASSWORD|\danog\MadelineProto\API::LOGGED_IN|API::LOGGED_OUT
     */
    public function getAuthorization(): int
    {
        return $this->wrapper->getAPI()->getAuthorization();
    }
    /**
     * Get the progress of a currently running broadcast.
     *
     * Will return null if the broadcast doesn't exist, has already completed or was cancelled.
     *
     * Use updateBroadcastProgress updates to get real-time progress status without polling.
     *
     * @param integer $id Broadcast ID
     */
    public function getBroadcastProgress(int $id): ?\danog\MadelineProto\Broadcast\Progress
    {
        return $this->wrapper->getAPI()->getBroadcastProgress($id);
    }
    /**
     * Get cached server-side config.
     */
    public function getCachedConfig(): array
    {
        return $this->wrapper->getAPI()->getCachedConfig();
    }
    /**
     * Get phone call information.
     */
    public function getCall(int $id): ?\danog\MadelineProto\VoIP
    {
        return $this->wrapper->getAPI()->getCall($id);
    }
    /**
     * Get the phone call with the specified user ID.
     */
    public function getCallByPeer(int $userId): ?\danog\MadelineProto\VoIP
    {
        return $this->wrapper->getAPI()->getCallByPeer($userId);
    }
    /**
     * Get call state.
     */
    public function getCallState(int $id): ?\danog\MadelineProto\VoIP\CallState
    {
        return $this->wrapper->getAPI()->getCallState($id);
    }
    /**
     * Store RSA keys for CDN datacenters.
     */
    public function getCdnConfig(): void
    {
        $this->wrapper->getAPI()->getCdnConfig();
    }
    /**
     * Get cached (or eventually re-fetch) server-side config.
     *
     * @param array $config Current config
     */
    public function getConfig(array $config = [
    ]): array
    {
        return $this->wrapper->getAPI()->getConfig($config);
    }
    /**
     * Get async DNS client.
     */
    public function getDNSClient(): \Amp\Dns\DnsResolver
    {
        return $this->wrapper->getAPI()->getDNSClient();
    }
    /**
     * Get diffie-hellman configuration.
     */
    public function getDhConfig(): array
    {
        return $this->wrapper->getAPI()->getDhConfig();
    }
    /**
     * Get dialog IDs.
     *
     * @return list<int>
     */
    public function getDialogIds(): array
    {
        return $this->wrapper->getAPI()->getDialogIds();
    }
    /**
     * Get download info of file
     * Returns an array with the following structure:.
     *
     * `$info['ext']` - The file extension
     * `$info['name']` - The file name, without the extension
     * `$info['mime']` - The file mime type
     * `$info['size']` - The file size
     *
     * @param mixed $messageMedia File ID
     *
     * @return array{
     *      ext: string,
     *      name: string,
     *      mime: string,
     *      size: int,
     *      InputFileLocation: array,
     *      key_fingerprint?: string,
     *      key?: string,
     *      iv?: string,
     *      thumb_size?: string
     * }
     */
    public function getDownloadInfo(mixed $messageMedia): array
    {
        return $this->wrapper->getAPI()->getDownloadInfo($messageMedia);
    }
    /**
     * Get download link of media file.
     */
    public function getDownloadLink(\danog\MadelineProto\EventHandler\Message|\danog\MadelineProto\EventHandler\Media|array|string $media, ?string $scriptUrl = null, ?int $size = null, ?string $name = null, ?string $mime = null): string
    {
        return $this->wrapper->getAPI()->getDownloadLink($media, $scriptUrl, $size, $name, $mime);
    }
    /**
     * Get event handler (or plugin instance).
     *
     * @template T as EventHandler
     *
     * @param class-string<T>|null $class
     *
     * @return T|EventHandlerProxy|__PHP_Incomplete_Class|null
     */
    public function getEventHandler(?string $class = null): \danog\MadelineProto\EventHandler|\danog\MadelineProto\Ipc\EventHandlerProxy|\__PHP_Incomplete_Class|null
    {
        return $this->wrapper->getAPI()->getEventHandler($class);
    }
    /**
     * Get extension from file location.
     *
     * @param mixed  $location File location
     * @param string $default  Default extension
     */
    public static function getExtensionFromLocation(mixed $location, string $default): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getExtensionFromLocation($location, $default);
    }
    /**
     * Get extension from mime type.
     *
     * @param string $mime MIME type
     */
    public static function getExtensionFromMime(string $mime): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getExtensionFromMime($mime);
    }
    /**
     * Get info about file.
     *
     * @param mixed $constructor File ID
     */
    public function getFileInfo(mixed $constructor): array
    {
        return $this->wrapper->getAPI()->getFileInfo($constructor);
    }
    /**
     * Get full info of all dialogs.
     *
     * Bots should use getDialogIds, instead.
     *
     * @return array<int, array>
     */
    public function getFullDialogs(): array
    {
        return $this->wrapper->getAPI()->getFullDialogs();
    }
    /**
     * Get full info about peer, returns an FullInfo object.
     *
     * @param mixed $id Peer
     * @see https://docs.madelineproto.xyz/FullInfo.html
     */
    public function getFullInfo(mixed $id): array
    {
        return $this->wrapper->getAPI()->getFullInfo($id);
    }
    /**
     * Get async HTTP client.
     */
    public function getHTTPClient(): \Amp\Http\Client\HttpClient
    {
        return $this->wrapper->getAPI()->getHTTPClient();
    }
    /**
     * Get current password hint.
     */
    public function getHint(): string
    {
        return $this->wrapper->getAPI()->getHint();
    }
    /**
     * Get the bot API ID of a peer.
     *
     * @param mixed $id Peer
     */
    public function getId(mixed $id): int
    {
        return $this->wrapper->getAPI()->getId($id);
    }
    /**
     * Get info about peer, returns an Info object.
     *
     * If passed a secret chat ID, returns information about the user, not about the secret chat.
     * Use getSecretChat to return information about the secret chat.
     *
     * @param mixed                                 $id   Peer
     * @param \danog\MadelineProto\API::INFO_TYPE_* $type Whether to generate an Input*, an InputPeer or the full set of constructors
     * @see https://docs.madelineproto.xyz/Info.html
     * @return ($type is \danog\MadelineProto\API::INFO_TYPE_ALL ? array{
     *      User?: array,
     *      Chat?: array,
     *      bot_api_id: int,
     *      user_id?: int,
     *      chat_id?: int,
     *      channel_id?: int,
     *      type: string
     * } : ($type is API::INFO_TYPE_TYPE ? string : ($type is \danog\MadelineProto\API::INFO_TYPE_ID ? int : array{_: string, user_id?: int, access_hash?: int, min?: bool, chat_id?: int, channel_id?: int}|array{_: string, user_id?: int, access_hash?: int, min?: bool}|array{_: string, channel_id: int, access_hash: int, min: bool})))
     */
    public function getInfo(mixed $id, int $type = \danog\MadelineProto\API::INFO_TYPE_ALL): array|string|int
    {
        return $this->wrapper->getAPI()->getInfo($id, $type);
    }
    /**
     * Get logger.
     */
    public function getLogger(): \danog\MadelineProto\Logger
    {
        return $this->wrapper->getAPI()->getLogger();
    }
    /**
     * Get current number of memory-mapped regions, UNIX only.
     */
    public static function getMaps(): ?int
    {
        return \danog\MadelineProto\Tools::getMaps();
    }
    /**
     * Get maximum number of memory-mapped regions, UNIX only.
     * Use testFibers to get the maximum number of fibers on any platform.
     */
    public static function getMaxMaps(): ?int
    {
        return \danog\MadelineProto\Tools::getMaxMaps();
    }
    /**
     * Get TL namespaces.
     */
    public function getMethodNamespaces(): array
    {
        return $this->wrapper->getAPI()->getMethodNamespaces();
    }
    /**
     * Get namespaced methods (method => namespace).
     */
    public function getMethodsNamespaced(): array
    {
        return $this->wrapper->getAPI()->getMethodsNamespaced();
    }
    /**
     * Get mime type from buffer.
     *
     * @param string $buffer Buffer
     */
    public static function getMimeFromBuffer(string $buffer): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getMimeFromBuffer($buffer);
    }
    /**
     * Get mime type from file extension.
     *
     * @param string $extension File extension
     * @param string $default   Default mime type
     */
    public static function getMimeFromExtension(string $extension, string $default): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getMimeFromExtension($extension, $default);
    }
    /**
     * Get mime type of file.
     *
     * @param string $file File
     */
    public static function getMimeFromFile(string $file): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getMimeFromFile($file);
    }
    /**
     * Obtain a certain event handler plugin instance.
     *
     * @template T as EventHandler
     *
     * @param class-string<T> $class
     *
     * return T|null
     */
    public function getPlugin(string $class): \danog\MadelineProto\PluginEventHandler|\danog\MadelineProto\Ipc\EventHandlerProxy|null
    {
        return $this->wrapper->getAPI()->getPlugin($class);
    }
    /**
     * Get download info of the propic of a user
     * Returns an array with the following structure:.
     *
     * `$info['ext']` - The file extension
     * `$info['name']` - The file name, without the extension
     * `$info['mime']` - The file mime type
     * `$info['size']` - The file size
     */
    public function getPropicInfo($data): array
    {
        return $this->wrapper->getAPI()->getPropicInfo($data);
    }
    /**
     * Get PSR logger.
     */
    public function getPsrLogger(): \Psr\Log\LoggerInterface
    {
        return $this->wrapper->getAPI()->getPsrLogger();
    }
    /**
     * Get full info about peer (including full list of channel members), returns a Chat object.
     *
     * @param mixed $id Peer
     * @see https://docs.madelineproto.xyz/Chat.html
     */
    public function getPwrChat(mixed $id, bool $fullfetch = true): array
    {
        return $this->wrapper->getAPI()->getPwrChat($id, $fullfetch);
    }
    /**
     * Get secret chat.
     *
     * @param array|int $chat Secret chat ID
     */
    public function getSecretChat(array|int $chat): \danog\MadelineProto\SecretChats\SecretChat
    {
        return $this->wrapper->getAPI()->getSecretChat($chat);
    }
    /**
     * Gets a secret chat message.
     *
     * @param integer $chatId Secret chat ID.
     * @param integer $randomId Secret chat message ID.
     */
    public function getSecretMessage(int $chatId, int $randomId): \danog\MadelineProto\EventHandler\Message\SecretMessage
    {
        return $this->wrapper->getAPI()->getSecretMessage($chatId, $randomId);
    }
    /**
     * Get info about the logged-in user, cached.
     *
     * Use fullGetSelf to bypass the cache.
     */
    public function getSelf(): array|false
    {
        return $this->wrapper->getAPI()->getSelf();
    }
    /**
     * Returns the session name.
     */
    public function getSessionName(): string
    {
        return $this->wrapper->getAPI()->getSessionName();
    }
    /**
     * Return current settings.
     */
    public function getSettings(): \danog\MadelineProto\Settings
    {
        return $this->wrapper->getAPI()->getSettings();
    }
    /**
     * Get sponsored messages for channel.
     * This method will return an array of [sponsored message objects](https://docs.madelineproto.xyz/API_docs/constructors/sponsoredMessage.html).
     *
     * See [the API documentation](https://core.telegram.org/api/sponsored-messages) for more info on how to handle sponsored messages.
     *
     * @param int|string|array $peer Channel ID, or Update, or Message, or Peer.
     */
    public function getSponsoredMessages(array|string|int $peer): ?array
    {
        return $this->wrapper->getAPI()->getSponsoredMessages($peer);
    }
    /**
     * Provide a stream for a file, URL or amp stream.
     */
    public function getStream(\danog\MadelineProto\EventHandler\Message|\danog\MadelineProto\EventHandler\Media|\danog\MadelineProto\LocalFile|\danog\MadelineProto\RemoteUrl|\danog\MadelineProto\BotApiFileId|\Amp\ByteStream\ReadableStream $stream, ?\Amp\Cancellation $cancellation = null): \Amp\ByteStream\ReadableStream
    {
        return $this->wrapper->getAPI()->getStream($stream, $cancellation);
    }
    /**
     * Obtains a pipe that can be used to upload a file from a stream.
     *
     */
    public static function getStreamPipe(): \Amp\ByteStream\Pipe
    {
        return \danog\MadelineProto\Tools::getStreamPipe();
    }
    /**
     * Get TL serializer.
     */
    public function getTL(): \danog\MadelineProto\TL\TLInterface
    {
        return $this->wrapper->getAPI()->getTL();
    }
    /**
     * Get type of peer.
     *
     * @param mixed $id Peer
     *
     * @return \danog\MadelineProto\API::PEER_TYPE_*
     */
    public function getType(mixed $id): string
    {
        return $this->wrapper->getAPI()->getType($id);
    }
    /**
     * Only useful when consuming MadelineProto updates through an API in another language (like Javascript), **absolutely not recommended when directly writing MadelineProto bots**.
     *
     * `getUpdates` will **greatly slow down your bot** if used directly inside of PHP code.
     *
     * **Only use the [event handler](#async-event-driven) when writing a MadelineProto bot**, because update handling in the **event handler** is completely parallelized and non-blocking.
     *
     * @param  array{offset?: int, limit?: int, timeout?: float} $params Params
     * @return list<array{update_id: mixed, update: mixed}>
     */
    public function getUpdates(array $params = [
    ]): array
    {
        return $this->wrapper->getAPI()->getUpdates($params);
    }
    /**
     * Get a message to show to the user when starting the bot.
     */
    public function getWebMessage(string $message): string
    {
        return $this->wrapper->getAPI()->getWebMessage($message);
    }
    /**
     * Get various warnings to show to the user in the web UI.
     */
    public static function getWebWarnings(): string
    {
        return \danog\MadelineProto\MTProto::getWebWarnings();
    }
    /**
     * Check if has admins.
     */
    public function hasAdmins(): bool
    {
        return $this->wrapper->getAPI()->hasAdmins();
    }
    /**
     * Check if an event handler instance is present.
     */
    public function hasEventHandler(): bool
    {
        return $this->wrapper->getAPI()->hasEventHandler();
    }
    /**
     * Check if a certain event handler plugin is installed.
     *
     * @param class-string<EventHandler> $class
     */
    public function hasPlugin(string $class): bool
    {
        return $this->wrapper->getAPI()->hasPlugin($class);
    }
    /**
     * Check if has report peers.
     */
    public function hasReportPeers(): bool
    {
        return $this->wrapper->getAPI()->hasReportPeers();
    }
    /**
     * Check whether secret chat exists.
     *
     * @param array|int $chat Secret chat ID
     */
    public function hasSecretChat(array|int $chat): bool
    {
        return $this->wrapper->getAPI()->hasSecretChat($chat);
    }
    /**
     * Escape string for MadelineProto's HTML entity converter.
     *
     * @param string $what String to escape
     */
    public static function htmlEscape(string $what): string
    {
        return \danog\MadelineProto\StrTools::htmlEscape($what);
    }
    /**
     * Manually convert HTML to a message and a set of entities.
     *
     * NOTE: You don't have to use this method to send HTML messages.
     *
     * This method is already called automatically by using parse_mode: "HTML" in messages.sendMessage, messages.sendMedia, et cetera...
     *
     * @see https://docs.madelineproto.xyz/API_docs/methods/messages.sendMessage.html#usage-of-parse_mode
     *
     * @return \danog\MadelineProto\TL\Conversion\DOMEntities Object containing message and entities
     */
    public static function htmlToMessageEntities(string $html): \danog\MadelineProto\TL\Conversion\DOMEntities
    {
        return \danog\MadelineProto\StrTools::htmlToMessageEntities($html);
    }
    /**
     * Import authorization.
     *
     * @param array<int, string> $authorization Authorization info
     * @param int                $mainDcID      Main DC ID
     */
    public function importAuthorization(array $authorization, int $mainDcID): array
    {
        return $this->wrapper->getAPI()->importAuthorization($authorization, $mainDcID);
    }
    /**
     * Inflate stripped photosize to full JPG payload.
     *
     * @param string $stripped Stripped photosize
     */
    public static function inflateStripped(string $stripped): string
    {
        return \danog\MadelineProto\Tools::inflateStripped($stripped);
    }
    /**
     * Initialize self-restart hack.
     */
    public function initSelfRestart(): void
    {
        $this->wrapper->getAPI()->initSelfRestart();
    }
    /**
     * Whether this is altervista.
     */
    public static function isAltervista(): bool
    {
        return \danog\MadelineProto\Tools::isAltervista();
    }
    /**
     * Check if is array or similar (traversable && countable && arrayAccess).
     *
     * @param mixed $var Value to check
     */
    public static function isArrayOrAlike(mixed $var): bool
    {
        return \danog\MadelineProto\Tools::isArrayOrAlike($var);
    }
    /**
     * Check if the specified peer is a bot.
     *
     */
    public function isBot(mixed $peer): bool
    {
        return $this->wrapper->getAPI()->isBot($peer);
    }
    /**
     * Check if the specified peer is a forum.
     *
     */
    public function isForum(mixed $peer): bool
    {
        return $this->wrapper->getAPI()->isForum($peer);
    }
    /**
     * Whether we're an IPC client instance.
     */
    public function isIpc(): bool
    {
        return $this->wrapper->getAPI()->isIpc();
    }
    /**
     * Whether we're an IPC server process (as opposed to an event handler).
     */
    public function isIpcWorker(): bool
    {
        return $this->wrapper->getAPI()->isIpcWorker();
    }
    /**
     * Whether the currently playing audio file is paused.
     */
    public function isPlayPaused(int $id): bool
    {
        return $this->wrapper->getAPI()->isPlayPaused($id);
    }
    /**
     * Returns whether the current user is a premium user, cached.
     */
    public function isPremium(): bool
    {
        return $this->wrapper->getAPI()->isPremium();
    }
    /**
     * Returns whether the current user is a bot.
     */
    public function isSelfBot(): bool
    {
        return $this->wrapper->getAPI()->isSelfBot();
    }
    /**
     * Returns whether the current user is a user.
     */
    public function isSelfUser(): bool
    {
        return $this->wrapper->getAPI()->isSelfUser();
    }
    /**
     * Whether we're currently connected to the test DCs.
     *
     * @return boolean
     */
    public function isTestMode(): bool
    {
        return $this->wrapper->getAPI()->isTestMode();
    }
    /**
     * Logger.
     *
     * @param mixed  $param Parameter
     * @param int    $level Logging level
     * @param string $file  File where the message originated
     */
    public function logger(mixed $param, int $level = \danog\MadelineProto\Logger::NOTICE, string $file = ''): void
    {
        $this->wrapper->getAPI()->logger($param, $level, $file);
    }
    /**
     * Logout the session.
     */
    public function logout(): void
    {
        $this->wrapper->getAPI()->logout();
    }
    /**
     * Escape string for markdown code section.
     *
     * @param string $what String to escape
     */
    public static function markdownCodeEscape(string $what): string
    {
        return \danog\MadelineProto\StrTools::markdownCodeEscape($what);
    }
    /**
     * Escape string for markdown codeblock.
     *
     * @param string $what String to escape
     */
    public static function markdownCodeblockEscape(string $what): string
    {
        return \danog\MadelineProto\StrTools::markdownCodeblockEscape($what);
    }
    /**
     * Escape string for markdown.
     *
     * @param string $what String to escape
     */
    public static function markdownEscape(string $what): string
    {
        return \danog\MadelineProto\StrTools::markdownEscape($what);
    }
    /**
     * Manually convert markdown to a message and a set of entities.
     *
     * NOTE: You don't have to use this method to send Markdown messages.
     *
     * This method is already called automatically by using parse_mode: "Markdown" in messages.sendMessage, messages.sendMedia, et cetera...
     *
     * @see https://docs.madelineproto.xyz/API_docs/methods/messages.sendMessage.html#usage-of-parse_mode
     *
     * @return \danog\MadelineProto\TL\Conversion\MarkdownEntities Object containing message and entities
     */
    public static function markdownToMessageEntities(string $markdown): \danog\MadelineProto\TL\Conversion\MarkdownEntities
    {
        return \danog\MadelineProto\StrTools::markdownToMessageEntities($markdown);
    }
    /**
     * Escape string for URL.
     *
     * @param string $what String to escape
     */
    public static function markdownUrlEscape(string $what): string
    {
        return \danog\MadelineProto\StrTools::markdownUrlEscape($what);
    }
    /**
     * Telegram UTF-8 multibyte split.
     *
     * @param  string        $text   Text
     * @param  integer       $length Length
     * @return array<string>
     */
    public static function mbStrSplit(string $text, int $length): array
    {
        return \danog\MadelineProto\StrTools::mbStrSplit($text, $length);
    }
    /**
     * Get Telegram UTF-8 length of string.
     *
     * @param string $text Text
     */
    public static function mbStrlen(string $text): int
    {
        return \danog\MadelineProto\StrTools::mbStrlen($text);
    }
    /**
     * Telegram UTF-8 multibyte substring.
     *
     * @param string   $text   Text to substring
     * @param integer  $offset Offset
     * @param null|int $length Length
     */
    public static function mbSubstr(string $text, int $offset, ?int $length = null): string
    {
        return \danog\MadelineProto\StrTools::mbSubstr($text, $offset, $length);
    }
    /**
     * Provide a buffered reader for a file, URL or amp stream.
     *
     * @return Closure(int): ?string
     */
    public static function openBuffered(\danog\MadelineProto\LocalFile|\danog\MadelineProto\RemoteUrl|\Amp\ByteStream\ReadableStream $stream, ?\Amp\Cancellation $cancellation = null): \Closure
    {
        return \danog\MadelineProto\Tools::openBuffered($stream, $cancellation);
    }
    /**
     * Opens a file in append-only mode.
     *
     * @param string $path File path.
     */
    public static function openFileAppendOnly(string $path): \Amp\File\File
    {
        return \danog\MadelineProto\Tools::openFileAppendOnly($path);
    }
    /**
     * Convert double to binary version.
     *
     * @param float $value Value to convert
     */
    public static function packDouble(float $value): string
    {
        return \danog\MadelineProto\Tools::packDouble($value);
    }
    /**
     * Convert integer to base256 signed int.
     *
     * @param integer $value Value to convert
     */
    public static function packSignedInt(int $value): string
    {
        return \danog\MadelineProto\Tools::packSignedInt($value);
    }
    /**
     * Convert integer to base256 long.
     *
     * @param int $value Value to convert
     */
    public static function packSignedLong(int $value): string
    {
        return \danog\MadelineProto\Tools::packSignedLong($value);
    }
    /**
     * Convert value to unsigned base256 int.
     *
     * @param int $value Value
     */
    public static function packUnsignedInt(int $value): string
    {
        return \danog\MadelineProto\Tools::packUnsignedInt($value);
    }
    /**
     * Pauses playback of the current audio file in the call.
     */
    public function pausePlay(int $id): void
    {
        $this->wrapper->getAPI()->pausePlay($id);
    }
    /**
     * Check if peer is present in internal peer database.
     *
     * @param mixed $id Peer
     */
    public function peerIsset(mixed $id): bool
    {
        return $this->wrapper->getAPI()->peerIsset($id);
    }
    /**
     * Login as user.
     *
     * @param string  $number   Phone number
     * @param integer $sms_type SMS type
     */
    public function phoneLogin(string $number, int $sms_type = 5): array
    {
        return $this->wrapper->getAPI()->phoneLogin($number, $sms_type);
    }
    /**
     * Positive modulo
     * Works just like the % (modulus) operator, only returns always a postive number.
     *
     * @param int $a A
     * @param int $b B
     */
    public static function posmod(int $a, int $b): int
    {
        return \danog\MadelineProto\Tools::posmod($a, $b);
    }
    /**
     * Internal endpoint used by the download server.
     */
    public static function processDownloadServerPing(string $path, string $payload): void
    {
        \danog\MadelineProto\MTProto::processDownloadServerPing($path, $payload);
    }
    /**
     * Initiates QR code login.
     *
     * Returns a QR code login helper object, that can be used to render the QR code, display the link directly, wait for login, QR code expiration and much more.
     *
     * Returns null if we're already logged in, or if we're waiting for a password (use getAuthorization to distinguish between the two cases).
     */
    public function qrLogin(): ?\danog\MadelineProto\TL\Types\LoginQrCode
    {
        return $this->wrapper->getAPI()->qrLogin();
    }
    /**
     * Get secure random string of specified length.
     *
     * @param integer $length Length
     */
    public static function random(int $length): string
    {
        return \danog\MadelineProto\Tools::random($length);
    }
    /**
     * Get random integer.
     *
     * @param integer $modulus Modulus
     */
    public static function randomInt(int $modulus = 0): int
    {
        return \danog\MadelineProto\Tools::randomInt($modulus);
    }
    /**
     * Asynchronously read line.
     *
     * @param string $prompt Prompt
     */
    public static function readLine(string $prompt = '', ?\Amp\Cancellation $cancel = null): string
    {
        return \danog\MadelineProto\AsyncTools::readLine($prompt, $cancel);
    }
    /**
     * Refresh full peer cache for a certain peer.
     *
     * @param mixed $id The peer to refresh
     */
    public function refreshFullPeerCache(mixed $id): void
    {
        $this->wrapper->getAPI()->refreshFullPeerCache($id);
    }
    /**
     * Refresh peer cache for a certain peer.
     *
     */
    public function refreshPeerCache(mixed ...$ids): void
    {
        $this->wrapper->getAPI()->refreshPeerCache(...$ids);
    }
    /**
     * Report an error to the previously set peer.
     *
     * @param string $message   Error to report
     * @param string $parseMode Parse mode
     */
    public function report(string $message, string $parseMode = ''): void
    {
        $this->wrapper->getAPI()->report($message, $parseMode);
    }
    /**
     * Report memory profile with memprof.
     */
    public function reportMemoryProfile(): void
    {
        $this->wrapper->getAPI()->reportMemoryProfile();
    }
    /**
     * Request VoIP call.
     *
     * @param mixed $user User
     */
    public function requestCall(mixed $user): \danog\MadelineProto\VoIP
    {
        return $this->wrapper->getAPI()->requestCall($user);
    }
    /**
     * Request secret chat.
     *
     * @param mixed $user User to start secret chat with
     */
    public function requestSecretChat(mixed $user): int
    {
        return $this->wrapper->getAPI()->requestSecretChat($user);
    }
    /**
     * Reset the update state and fetch all updates from the beginning.
     */
    public function resetUpdateState(): void
    {
        $this->wrapper->getAPI()->resetUpdateState();
    }
    /**
     * Restart update loop.
     */
    public function restart(): void
    {
        $this->wrapper->getAPI()->restart();
    }
    /**
     * Resumes playback of the current audio file in the call.
     */
    public function resumePlay(int $id): void
    {
        $this->wrapper->getAPI()->resumePlay($id);
    }
    /**
     * Rethrow exception into event loop.
     */
    public static function rethrow(\Throwable $e): void
    {
        \danog\MadelineProto\AsyncTools::rethrow($e);
    }
    /**
     * null-byte RLE decode.
     *
     * @param string $string Data to decode
     */
    public static function rleDecode(string $string): string
    {
        return \danog\MadelineProto\Tools::rleDecode($string);
    }
    /**
     * null-byte RLE encode.
     *
     * @param string $string Data to encode
     */
    public static function rleEncode(string $string): string
    {
        return \danog\MadelineProto\Tools::rleEncode($string);
    }
    /**
     * Sends an updateCustomEvent update to the event handler.
     */
    public function sendCustomEvent(mixed $payload): void
    {
        $this->wrapper->getAPI()->sendCustomEvent($payload);
    }
    /**
     * Sends a document.
     *
     * Please use named arguments to call this method.
     *
     * @param integer|string                                                     $peer                   Destination peer or username.
     * @param Message|Media|LocalFile|RemoteUrl|BotApiFileId|ReadableStream      $file                   File to upload: can be a message to reuse media present in a message.
     * @param Message|Media|LocalFile|RemoteUrl|BotApiFileId|ReadableStream|null $thumb                  Optional: Thumbnail to upload
     * @param string                                                             $caption                Caption of document
     * @param ?callable(float, float, int)                                       $callback               Upload callback (percent, speed in mpbs, time elapsed)
     * @param ?string                                                            $fileName               Optional file name, if absent will be extracted from the passed $file.
     * @param ParseMode                                                          $parseMode              Text parse mode for the caption
     * @param integer|null                                                       $replyToMsgId           ID of message to reply to.
     * @param integer|null                                                       $topMsgId               ID of thread where to send the message.
     * @param array|null                                                         $replyMarkup            Keyboard information.
     * @param integer|null                                                       $sendAs                 Peer to send the message as.
     * @param integer|null                                                       $scheduleDate           Schedule date.
     * @param boolean                                                            $silent                 Whether to send the message silently, without triggering notifications.
     * @param boolean                                                            $background             Send this message as background message
     * @param boolean                                                            $clearDraft             Clears the draft field
     * @param boolean                                                            $updateStickersetsOrder Whether to move used stickersets to top
     * @param boolean                                                            $forceResend            Whether to forcefully resend the file, even if its type and name are the same.
     * @param Cancellation                                                       $cancellation           Cancellation.
     *
     */
    public function sendDocument(string|int $peer, \danog\MadelineProto\EventHandler\Message|\danog\MadelineProto\EventHandler\Media|\danog\MadelineProto\LocalFile|\danog\MadelineProto\RemoteUrl|\danog\MadelineProto\BotApiFileId|\Amp\ByteStream\ReadableStream $file, \danog\MadelineProto\EventHandler\Message|\danog\MadelineProto\EventHandler\Media|\danog\MadelineProto\LocalFile|\danog\MadelineProto\RemoteUrl|\danog\MadelineProto\BotApiFileId|\Amp\ByteStream\ReadableStream|null $thumb = null, string $caption = '', \danog\MadelineProto\ParseMode $parseMode = \danog\MadelineProto\ParseMode::TEXT, ?callable $callback = null, ?string $fileName = null, ?string $mimeType = null, ?int $ttl = null, bool $spoiler = false, ?int $replyToMsgId = null, ?int $topMsgId = null, ?array $replyMarkup = null, string|int|null $sendAs = null, ?int $scheduleDate = null, bool $silent = false, bool $noForwards = false, bool $background = false, bool $clearDraft = false, bool $updateStickersetsOrder = false, bool $forceResend = false, ?\Amp\Cancellation $cancellation = null): \danog\MadelineProto\EventHandler\Message
    {
        return $this->wrapper->getAPI()->sendDocument($peer, $file, $thumb, $caption, $parseMode, $callback, $fileName, $mimeType, $ttl, $spoiler, $replyToMsgId, $topMsgId, $replyMarkup, $sendAs, $scheduleDate, $silent, $noForwards, $background, $clearDraft, $updateStickersetsOrder, $forceResend, $cancellation);
    }
    /**
     * Sends a message.
     *
     * @param integer|string $peer                   Destination peer or username.
     * @param string         $message                Message to send
     * @param ParseMode      $parseMode              Parse mode
     * @param integer|null   $replyToMsgId           ID of message to reply to.
     * @param integer|null   $topMsgId               ID of thread where to send the message.
     * @param array|null     $replyMarkup            Keyboard information.
     * @param integer|null   $sendAs                 Peer to send the message as.
     * @param integer|null   $scheduleDate           Schedule date.
     * @param boolean        $silent                 Whether to send the message silently, without triggering notifications.
     * @param boolean        $background             Send this message as background message
     * @param boolean        $clearDraft             Clears the draft field
     * @param boolean        $noWebpage              Set this flag to disable generation of the webpage preview
     * @param boolean        $updateStickersetsOrder Whether to move used stickersets to top
     * @param ?Cancellation  $cancellation           Cancellation
     */
    public function sendMessage(string|int $peer, string $message, \danog\MadelineProto\ParseMode $parseMode = \danog\MadelineProto\ParseMode::TEXT, ?int $replyToMsgId = null, ?int $topMsgId = null, ?array $replyMarkup = null, string|int|null $sendAs = null, ?int $scheduleDate = null, bool $silent = false, bool $noForwards = false, bool $background = false, bool $clearDraft = false, bool $noWebpage = false, bool $updateStickersetsOrder = false, ?\Amp\Cancellation $cancellation = null): \danog\MadelineProto\EventHandler\Message
    {
        return $this->wrapper->getAPI()->sendMessage($peer, $message, $parseMode, $replyToMsgId, $topMsgId, $replyMarkup, $sendAs, $scheduleDate, $silent, $noForwards, $background, $clearDraft, $noWebpage, $updateStickersetsOrder, $cancellation);
    }
    /**
     * Sends a message to all report peers (admins of the bot).
     *
     * @param string       $message      Message to send
     * @param ParseMode    $parseMode    Parse mode
     * @param array|null   $replyMarkup  Keyboard information.
     * @param integer|null $scheduleDate Schedule date.
     * @param boolean      $silent       Whether to send the message silently, without triggering notifications.
     * @param boolean      $background   Send this message as background message
     * @param boolean      $clearDraft   Clears the draft field
     * @param boolean      $noWebpage    Set this flag to disable generation of the webpage preview
     *
     * @return list<\danog\MadelineProto\EventHandler\Message>
     */
    public function sendMessageToAdmins(string $message, \danog\MadelineProto\ParseMode $parseMode = \danog\MadelineProto\ParseMode::TEXT, ?array $replyMarkup = null, ?int $scheduleDate = null, bool $silent = false, bool $noForwards = false, bool $background = false, bool $clearDraft = false, bool $noWebpage = false, ?\Amp\Cancellation $cancellation = null): array
    {
        return $this->wrapper->getAPI()->sendMessageToAdmins($message, $parseMode, $replyMarkup, $scheduleDate, $silent, $noForwards, $background, $clearDraft, $noWebpage, $cancellation);
    }
    /**
     * Sends a photo.
     *
     * Please use named arguments to call this method.
     *
     * @param integer|string                                                $peer                   Destination peer or username.
     * @param Message|Media|LocalFile|RemoteUrl|BotApiFileId|ReadableStream $file                   File to upload: can be a message to reuse media present in a message.
     * @param string                                                        $caption                Caption of document
     * @param ?callable(float, float, int)                                  $callback               Upload callback (percent, speed in mpbs, time elapsed)
     * @param ?string                                                       $fileName               Optional file name, if absent will be extracted from the passed $file.
     * @param ParseMode                                                     $parseMode              Text parse mode for the caption
     * @param integer|null                                                  $replyToMsgId           ID of message to reply to.
     * @param integer|null                                                  $topMsgId               ID of thread where to send the message.
     * @param array|null                                                    $replyMarkup            Keyboard information.
     * @param integer|null                                                  $sendAs                 Peer to send the message as.
     * @param integer|null                                                  $scheduleDate           Schedule date.
     * @param boolean                                                       $silent                 Whether to send the message silently, without triggering notifications.
     * @param boolean                                                       $background             Send this message as background message
     * @param boolean                                                       $clearDraft             Clears the draft field
     * @param boolean                                                       $updateStickersetsOrder Whether to move used stickersets to top
     * @param boolean                                                       $forceResend            Whether to forcefully resend the file, even if its type and name are the same.
     * @param Cancellation                                                  $cancellation           Cancellation.
     *
     */
    public function sendPhoto(string|int $peer, \danog\MadelineProto\EventHandler\Message|\danog\MadelineProto\EventHandler\Media|\danog\MadelineProto\LocalFile|\danog\MadelineProto\RemoteUrl|\danog\MadelineProto\BotApiFileId|\Amp\ByteStream\ReadableStream $file, string $caption = '', \danog\MadelineProto\ParseMode $parseMode = \danog\MadelineProto\ParseMode::TEXT, ?callable $callback = null, ?string $fileName = null, ?int $ttl = null, bool $spoiler = false, ?int $replyToMsgId = null, ?int $topMsgId = null, ?array $replyMarkup = null, string|int|null $sendAs = null, ?int $scheduleDate = null, bool $silent = false, bool $noForwards = false, bool $background = false, bool $clearDraft = false, bool $updateStickersetsOrder = false, bool $forceResend = false, ?\Amp\Cancellation $cancellation = null): \danog\MadelineProto\EventHandler\Message
    {
        return $this->wrapper->getAPI()->sendPhoto($peer, $file, $caption, $parseMode, $callback, $fileName, $ttl, $spoiler, $replyToMsgId, $topMsgId, $replyMarkup, $sendAs, $scheduleDate, $silent, $noForwards, $background, $clearDraft, $updateStickersetsOrder, $forceResend, $cancellation);
    }
    /**
     * Set NOOP update handler, ignoring all updates.
     */
    public function setNoop(): void
    {
        $this->wrapper->getAPI()->setNoop();
    }
    /**
     * Set peer(s) where to send errors occurred in the event loop.
     *
     * @param int|string|array<int|string> $userOrId Username(s) or peer ID(s)
     */
    public function setReportPeers(array|string|int $userOrId): void
    {
        $this->wrapper->getAPI()->setReportPeers($userOrId);
    }
    /**
     * Set webhook update handler.
     *
     * @param string $webhookUrl Webhook URL
     */
    public function setWebhook(string $webhookUrl): void
    {
        $this->wrapper->getAPI()->setWebhook($webhookUrl);
    }
    /**
     * When called, skips to the next file in the playlist.
     */
    public function skipPlay(int $id): void
    {
        $this->wrapper->getAPI()->skipPlay($id);
    }
    /**
     * Asynchronously sleep.
     *
     * @param float $time Number of seconds to sleep for
     */
    public static function sleep(float $time): void
    {
        \danog\MadelineProto\AsyncTools::sleep($time);
    }
    /**
     * Log in to telegram (via CLI or web).
     */
    public function start(): array
    {
        return $this->wrapper->getAPI()->start();
    }
    /**
     * Stop update loop.
     */
    public function stop(): void
    {
        $this->wrapper->getAPI()->stop();
    }
    /**
     * Stops playing all files in the call, clears the main and the hold playlist.
     */
    public function stopPlay(int $id): void
    {
        $this->wrapper->getAPI()->stopPlay($id);
    }
    /**
     * Converts a string into an async amphp stream.
     */
    public static function stringToStream(string $str): \Amp\ByteStream\ReadableBuffer
    {
        return \danog\MadelineProto\Tools::stringToStream($str);
    }
    /**
     * Subscribe to event handler updates for a channel/supergroup we're not a member of.
     *
     * @param mixed $channel Channel/supergroup to subscribe to
     *
     * @return bool False if we were already subscribed
     */
    public function subscribeToUpdates(mixed $channel): bool
    {
        return $this->wrapper->getAPI()->subscribeToUpdates($channel);
    }
    /**
     * Convert TD to MTProto parameters.
     *
     * @param array $params Parameters
     */
    public function tdToMTProto(array $params): array
    {
        return $this->wrapper->getAPI()->tdToMTProto($params);
    }
    /**
     * Convert TD parameters to tdcli.
     *
     * @param mixed $params Parameters
     */
    public function tdToTdcli(mixed $params): array
    {
        return $this->wrapper->getAPI()->tdToTdcli($params);
    }
    /**
     * Convert tdcli parameters to tdcli.
     *
     * @param mixed $params Params
     * @param array $key    Key
     */
    public function tdcliToTd(&$params, ?array $key = null): array
    {
        return $this->wrapper->getAPI()->tdcliToTd($params, $key);
    }
    /**
     * Test fibers.
     *
     * @return array{maxFibers: int, realMemoryMb: int, maps: ?int, maxMaps: ?int}
     */
    public static function testFibers(int $fiberCount = 100000): array
    {
        return \danog\MadelineProto\Tools::testFibers($fiberCount);
    }
    /**
     * Convert to camelCase.
     *
     * @param string $input String
     */
    public static function toCamelCase(string $input): string
    {
        return \danog\MadelineProto\StrTools::toCamelCase($input);
    }
    /**
     * Convert to snake_case.
     *
     * @param string $input String
     */
    public static function toSnakeCase(string $input): string
    {
        return \danog\MadelineProto\StrTools::toSnakeCase($input);
    }
    /**
     * Unpack binary double.
     *
     * @param string $value Value to unpack
     */
    public static function unpackDouble(string $value): float
    {
        return \danog\MadelineProto\Tools::unpackDouble($value);
    }
    /**
     * Unpack bot API file ID.
     *
     * @param  string $fileId Bot API file ID
     * @return array  Unpacked file ID
     */
    public static function unpackFileId(string $fileId): array
    {
        return \danog\MadelineProto\MTProto::unpackFileId($fileId);
    }
    /**
     * Unpack base256 signed int.
     *
     * @param string $value base256 int
     */
    public static function unpackSignedInt(string $value): int
    {
        return \danog\MadelineProto\Tools::unpackSignedInt($value);
    }
    /**
     * Unpack base256 signed long.
     *
     * @param string $value base256 long
     */
    public static function unpackSignedLong(string $value): int
    {
        return \danog\MadelineProto\Tools::unpackSignedLong($value);
    }
    /**
     * Unpack base256 signed long to string.
     *
     * @param string|int|array $value base256 long
     */
    public static function unpackSignedLongString(array|string|int $value): string
    {
        return \danog\MadelineProto\Tools::unpackSignedLongString($value);
    }
    /**
     * Unset event handler.
     *
     */
    public function unsetEventHandler(): void
    {
        $this->wrapper->getAPI()->unsetEventHandler();
    }
    /**
     * Update the 2FA password.
     *
     * The params array can contain password, new_password, email and hint params.
     *
     * @param array{password?: string, new_password?: string, email?: string, hint?: string} $params The params
     */
    public function update2fa(array $params): void
    {
        $this->wrapper->getAPI()->update2fa($params);
    }
    /**
     * Parse, update and store settings.
     *
     * @param SettingsAbstract $settings Settings
     */
    public function updateSettings(\danog\MadelineProto\SettingsAbstract $settings): void
    {
        $this->wrapper->getAPI()->updateSettings($settings);
    }
    /**
     * Upload file.
     *
     * @param FileCallbackInterface|LocalFile|RemoteUrl|BotApiFileId|string|array|resource $file      File, URL or Telegram file to upload
     * @param string                                                                       $fileName  File name
     * @param callable                                                                     $cb        Callback
     * @param boolean                                                                      $encrypted Whether to encrypt file for secret chats
     *
     * @return array InputFile constructor
     */
    public function upload($file, string $fileName = '', ?callable $cb = null, bool $encrypted = false, ?\Amp\Cancellation $cancellation = null): array
    {
        return $this->wrapper->getAPI()->upload($file, $fileName, $cb, $encrypted, $cancellation);
    }
    /**
     * Upload file to secret chat.
     *
     * @param FileCallbackInterface|LocalFile|RemoteUrl|BotApiFileId|string|array|resource $file      File, URL or Telegram file to upload
     * @param string                             $fileName File name
     * @param callable                           $cb       Callback
     *
     * @return array InputFile constructor
     */
    public function uploadEncrypted($file, string $fileName = '', ?callable $cb = null, ?\Amp\Cancellation $cancellation = null): array
    {
        return $this->wrapper->getAPI()->uploadEncrypted($file, $fileName, $cb, $cancellation);
    }
    /**
     * Upload file from callable.
     *
     * The callable must accept two parameters: int $offset, int $size
     * The callable must return a string with the contest of the file at the specified offset and size.
     *
     * @param callable(int, int, ?Cancellation): string $callable  Callable (offset, length) => data
     * @param integer                                   $size      File size
     * @param string                                    $mime      Mime type
     * @param string                                    $fileName  File name
     * @param callable(float, float, float): void       $cb        Status callback
     * @param boolean                                   $seekable  Whether chunks can be fetched out of order
     * @param boolean                                   $encrypted Whether to encrypt file for secret chats
     *
     * @return array InputFile constructor
     */
    public function uploadFromCallable(callable $callable, int $size = 0, string $mime = 'application/octet-stream', string $fileName = '', ?callable $cb = null, bool $seekable = true, bool $encrypted = false, ?\Amp\Cancellation $cancellation = null): array
    {
        return $this->wrapper->getAPI()->uploadFromCallable($callable, $size, $mime, $fileName, $cb, $seekable, $encrypted, $cancellation);
    }
    /**
     * Upload file from stream.
     *
     * @param mixed    $stream    PHP resource or AMPHP async stream
     * @param integer  $size      File size
     * @param string   $mime      Mime type
     * @param string   $fileName  File name
     * @param callable $cb        Callback
     * @param boolean  $encrypted Whether to encrypt file for secret chats
     *
     * @return array InputFile constructor
     */
    public function uploadFromStream(mixed $stream, int $size = 0, string $mime = 'application/octet-stream', string $fileName = '', ?callable $cb = null, bool $encrypted = false, ?\Amp\Cancellation $cancellation = null): array
    {
        return $this->wrapper->getAPI()->uploadFromStream($stream, $size, $mime, $fileName, $cb, $encrypted, $cancellation);
    }
    /**
     * Reupload telegram file.
     *
     * @param mixed    $media     Telegram file
     * @param callable $cb        Callback
     * @param boolean  $encrypted Whether to encrypt file for secret chats
     *
     * @return array InputFile constructor
     */
    public function uploadFromTgfile(mixed $media, ?callable $cb = null, bool $encrypted = false, ?\Amp\Cancellation $cancellation = null): array
    {
        return $this->wrapper->getAPI()->uploadFromTgfile($media, $cb, $encrypted, $cancellation);
    }
    /**
     * Upload file from URL.
     *
     * @param  string|FileCallbackInterface $url       URL of file
     * @param  integer                      $size      Size of file
     * @param  string                       $fileName  File name
     * @param  callable                     $cb        Callback
     * @param  boolean                      $encrypted Whether to encrypt file for secret chats
     * @return array                        InputFile constructor
     */
    public function uploadFromUrl(\danog\MadelineProto\FileCallbackInterface|string $url, int $size = 0, string $fileName = '', ?callable $cb = null, bool $encrypted = false, ?\Amp\Cancellation $cancellation = null): array
    {
        return $this->wrapper->getAPI()->uploadFromUrl($url, $size, $fileName, $cb, $encrypted, $cancellation);
    }
    /**
     * Perform static analysis on a certain event handler class, to make sure it satisfies some performance requirements.
     *
     * @param class-string<EventHandler> $class Class name
     *
     * @return list<EventHandlerIssue>
     */
    public static function validateEventHandlerClass(string $class): array
    {
        return \danog\MadelineProto\Tools::validateEventHandlerClass($class);
    }
    /**
     * Mark sponsored message as read.
     *
     * @param int|array                       $peer    Channel ID, or Update, or Message, or Peer.
     * @param string|array{random_id: string} $message Random ID or sponsored message to mark as read.
     */
    public function viewSponsoredMessage(array|int $peer, array|string $message): bool
    {
        return $this->wrapper->getAPI()->viewSponsoredMessage($peer, $message);
    }
    /**
     * Wrap a media constructor into an abstract Media object.
     */
    public function wrapMedia(array $media, bool $protected = false): ?\danog\MadelineProto\EventHandler\Media
    {
        return $this->wrapper->getAPI()->wrapMedia($media, $protected);
    }
    /**
     * Wrap a Message constructor into an abstract Message object.
     */
    public function wrapMessage(array $message): ?\danog\MadelineProto\EventHandler\AbstractMessage
    {
        return $this->wrapper->getAPI()->wrapMessage($message);
    }
    /**
     * Wrap a Pin constructor into an abstract Pinned object.
     */
    public function wrapPin(array $message): ?\danog\MadelineProto\EventHandler\Pinned
    {
        return $this->wrapper->getAPI()->wrapPin($message);
    }
    /**
     * Wrap an Update constructor into an abstract Update object.
     */
    public function wrapUpdate(array $update): ?\danog\MadelineProto\EventHandler\Update
    {
        return $this->wrapper->getAPI()->wrapUpdate($update);
    }
}
